Scriptname eogeomQuestLightningOrderScript extends Quest  

import Utility

Int LightningOrderCharged
int Property LightningOrderTrigger Auto

float ftimeStart
float ftimeEnd

Spell Property eogeomSpellEoGeom  Auto
Spell Property eogeomSpellLightningOrder01  Auto
Spell Property eogeomSpellLightningExplosion Auto

Sound Property eogeomSoundLightningCharge  Auto

EffectShader Property LightningOrderFXSCharged  Auto

VisualEffect Property eogeomVisualOn01  Auto
VisualEffect Property eogeomVisualOn02  Auto
VisualEffect Property eogeomVisualOn03  Auto
VisualEffect Property eogeomVisualOn04  Auto
VisualEffect Property eogeomVisualOn05  Auto
VisualEffect Property eogeomVisualOn06  Auto

VisualEffect Property eogeomVisualLightningOrder01  Auto
VisualEffect Property eogeomVisualLightningOrder02  Auto
VisualEffect Property eogeomVisualLightningOrder03  Auto
VisualEffect Property eogeomVisualLightningOrder04  Auto
VisualEffect Property eogeomVisualLightningOrder05  Auto
VisualEffect Property eogeomVisualLightningOrder06  Auto

VisualEffect Property eogeomVisualLightning01  Auto
VisualEffect Property eogeomVisualLightning02  Auto
VisualEffect Property eogeomVisualLightning03  Auto
VisualEffect Property eogeomVisualLightning04  Auto

GlobalVariable Property eogeomLightningOrderChargeTime  Auto

eogeomQuestTriggerScript Property eogeom  Auto

Event onInit()                       ; This event will run once, when the script is initialized

	LightningOrderCharged = 0
	LightningOrderTrigger = 0

	RegisterForSingleUpdate(0.01)

endEvent

Event OnUpdate()

	Actor PlayerActor =  Game.GetPlayer()

	RegisterForControl("Shout")

	if (PlayerActor.GetEquippedSpell(2) == eogeomSpellEoGeom) && LightningOrderTrigger == 0

		If LightningOrderCharged == 1

			ftimeEnd = GetCurrentRealTime()

			if ftimeEnd - ftimeStart >= eogeomLightningOrderChargeTime.getValue()

				If eogeom.Set06 == 1 && eogeom.Set05 == 1 && eogeom.Set04 == 1 && eogeom.Set03 == 1 && eogeom.Set02 == 1 && eogeom.Set01 == 1

					LightningOrderFXSCharged.play(PlayerActor, 1.0)

					eogeomSoundLightningCharge.play(PlayerActor)
					LightningOrderCharged = 2

				endIf
			endIf
		endIf
	endIf

	RegisterForSingleUpdate(0.01)

endEvent

Event OnControlDown(string control)

	Actor PlayerActor =  Game.GetPlayer()

	if (PlayerActor.GetEquippedSpell(2) == eogeomSpellEoGeom) && LightningOrderTrigger == 0

		If control == "Shout"

			LightningOrderCharged = 1
			ftimeStart = GetCurrentRealTime()

		EndIf
	EndIf

EndEvent

Event OnControlUp(string control, float HoldTime)

	Actor PlayerActor =  Game.GetPlayer()

	if (PlayerActor.GetEquippedSpell(2) == eogeomSpellEoGeom) && LightningOrderTrigger == 0

		If control == "Shout"
		
			LightningOrderCharged = 0

			If HoldTime >= eogeomLightningOrderChargeTime.getValue()

				If eogeom.Set06 == 1 && eogeom.Set05 == 1 && eogeom.Set04 == 1 && eogeom.Set03 == 1 && eogeom.Set02 == 1 && eogeom.Set01 == 1

					LightningOrderTrigger = 1
					eogeomSpellLightningExplosion.Cast(PlayerActor) 

					eogeomVisualOn06.stop(PlayerActor)
					eogeomVisualLightningOrder06.play(PlayerActor,0.3)
					eogeom.Set06 = 0

					eogeomVisualOn05.stop(PlayerActor)
					eogeomVisualLightningOrder05.play(PlayerActor,0.3)
					eogeom.Set05 = 0

					eogeomVisualOn04.stop(PlayerActor)
					eogeomVisualLightningOrder04.play(PlayerActor,0.3)
					eogeom.Set04 = 0

					eogeomVisualOn03.stop(PlayerActor)
					eogeomVisualLightningOrder03.play(PlayerActor,0.3)
					eogeom.Set03 = 0

					eogeomVisualOn02.stop(PlayerActor)
					eogeomVisualLightningOrder02.play(PlayerActor,0.3)
					eogeom.Set02 = 0

					eogeomVisualOn01.stop(PlayerActor)
					eogeomVisualLightningOrder01.play(PlayerActor,0.3)
					eogeom.Set01 = 0

					eogeomSpellLightningOrder01.Cast(PlayerActor)

				EndIf

			EndIf

		EndIf

	EndIf

EndEvent